<?php

/**
 *
 */
class ToolModel
{

    /**
     * get an inspection record for a given id
     * parameters id(int)
     * returns JSON string
     */
     public static function getInspectionRecord($id)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $results=array();
        $sql="SELECT * FROM inspection WHERE id=:id";
        $query = $database->prepare($sql);
        $parameters = array(':id' => $id);
        $query->execute($parameters);
        $inspection=$query->fetchAll(PDO::FETCH_ASSOC);
        $vehicleid=$inspection[0]['vehicleid'];
        $results['vehicleid']=$vehicleid;
        //get mappings for vehicle
        $sql="SELECT name FROM vehicle WHERE id=:vehicleid";
        $query = $database->prepare($sql);
        $parameters = array(':vehicleid' => $vehicleid);
        $query->execute($parameters);
        $results['vehicle']=$query->fetch()->name;
        $scheduleid=$inspection[0]['scheduleid'];
        //$scheduleid=1;
        $results['scheduleid']=$scheduleid;
        //get mappings for schedule
        $sql="SELECT value FROM inspectioninterval WHERE id=:scheduleid";
        $query = $database->prepare($sql);
        $parameters = array(':scheduleid' => $scheduleid);
        $query->execute($parameters);
        $results['id']=$id;
        $results['schedule']=$query->fetch()->value;
        $results['unit']=$inspection[0]['unit'];
        $results['vrn']=$inspection[0]['vrn'];
        $results['user']=$inspection[0]['user'];
        $results['recordid']=$inspection[0]['recordid'];
        $results['pods']=json_decode(Encryption::decrypt($inspection[0]['b_pods']),true);
        //$results['pods']=json_decode($inspection[0]['pods'],true);
        $results['version']=$inspection[0]['version'];
        $results['date']=$inspection[0]['date'];
        $results['odometer']=$inspection[0]['odometer'];
        $results['year']=date('Y', strtotime($inspection[0]['date']));
        //get pods structure
        $pods=array();
        $version=$inspection[0]['version'];
        //$version=2;
        $sql="SELECT b_poddata,name FROM view WHERE vehicleid=:vehicleid AND scheduleid=:scheduleid AND version=:version";
        $query = $database->prepare($sql);
        $parameters = array(':vehicleid' => $vehicleid,':scheduleid' => $scheduleid,':version' => $version);
        $query->execute($parameters);
        //echo '[ PDO DEBUG ]: ' . Helper::debugPDO($sql, $parameters);  exit();
        $podstructure=array();
        while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
           $view=$row['name'];
           //decode pod data
           //$poddata=json_decode($row['poddata']);
           $poddata=json_decode(Encryption::decrypt($row['b_poddata']));
           //print_r($poddata);
           foreach($poddata as $data){
              if(!$data->inspection->hidden){
                 $podstructure[$data->common->ssiid]=array("view" => $view,"common" => $data->common, "inspection" => $data->inspection);
                 //get repair data if repair report
                 if($scheduleid==14)$podstructure[$data->common->ssiid]['repair']=$data->repair;
                 if(Encryption::decrypt($inspection[0]['b_pods'])=='{}'){
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["ref"]=$data->common->ref;
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["ssiid"]=$data->common->ssiid;
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["flawsize"]="";
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["condemnationcriteria"]=$data->common->SI;
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["observation"]="";
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["complete"]=false;
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["metrics"]=array();
                    //repair report
                    if($scheduleid==14)$podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["repair"]=array("grs1"=>0,"grs2"=>0,"srs"=>0);
                    foreach($data->inspection->metrics as $metric){
                       $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["metrics"][]=array("id" => $metric->id, "value" => $metric->default);
                    }
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["sketch"]=array();
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["photo"]=array();
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["ndt"]=array();
                 }
                 else{
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]=$results['pods'][$data->common->ssiid];
                 }
              }
           }
        }
        $results['poddata']=json_encode($podstructure,JSON_PRETTY_PRINT);
        return $results;
     }

    /**
     * get a list of specific repair schemes for a given vrn and vehicleid
     * parameters vehicleid(int),vrn(string)
     * returns JSON string
     */
     public static function getSpecificRepairByVRN($vehicleid,$vrn)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $results=array();
        $filter=($vrn=='all')?'vrn!=:vrn':'vrn=:vrn';
        $sql="SELECT * FROM repairschemes WHERE vehicleid=:vehicleid AND type='specific' AND ".$filter;
        $query = $database->prepare($sql);
        $parameters=array(':vehicleid' => $vehicleid,':vrn' => $vrn);
        $query->execute($parameters);
        while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
           $results[]=array('id'=>$row['id'],'reference'=>$row['reference'],'description'=>$row['description'],'vrn'=>$row['vrn'],'title'=>$row['title']);
        }
        return json_encode($results,JSON_PRETTY_PRINT);
     }

    /**
     * create a blank inspection record
     * parameters vehicleid(int),version(int),unit(string),scheduleid(int),vrn(string),odometer(int)
     * returns int
     */
     public static function createInspectionRecord($vehicleid,$version,$unit,$scheduleid,$vrn,$odometer)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $recordid=uniqid();
        $username="admin";//this will be replaced by currently logged in username
        //encrypt empty braces for pods
        $pods=Encryption::encrypt("{}");

        $sql="INSERT INTO inspection(id,recordid, user, vrn, odometer, date, vehicleid, scheduleid, version, unit, metrics, b_pods) VALUES (null,:recordid,:username,:vrn,:odometer,CURDATE(),:vehicleid,:scheduleid,:version,:unit,'[]',:pods)";
        $query = $database->prepare($sql);
        $parameters = array(':recordid' => $recordid,':username' => $username,':vrn' => $vrn,':odometer' => $odometer,':vehicleid' => $vehicleid,':scheduleid' => $scheduleid, ':version' => $version,':unit' => $unit,':pods' => $pods);
        $query->execute($parameters);
        return $database->lastInsertId();

     }

    /**
     * gets an inspection view for given parameters
     * parameters vehicleid(int),scheduleid(int),type(string),view(string),version(int)
     * returns string
     */
     public static function getInspectionView($vehicleid,$scheduleid,$type,$view,$version)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $results="";
        $sql="SELECT name,image,b_poddata FROM view WHERE name=:view AND vehicleid=:vehicleid AND scheduleid=:scheduleid AND version=:version";
        $query = $database->prepare($sql);
        $parameters = array(':view'=>$view,':vehicleid' => $vehicleid,'scheduleid' => $scheduleid,':version'=>$version);
        $query->execute($parameters);
        while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
           $pods=json_decode(Encryption::decrypt($row['b_poddata']),true);
           $podarray=array();
           foreach ($pods as $pod){
              if(!$pod['inspection']['hidden']){
                 $poddata="";
                 $poddata.='{"top":'.$pod['top'].',"left":'.$pod['left'].',"ptop":'.$pod['ptop'].',"pleft":'.$pod['pleft'].',"ssiid":';
                 $poddata.=json_encode($pod['common']['ssiid']).'}';
                 $podarray[]=$poddata;
              }
           }
           $results='{"name":"'.$row['name'].'","image":"'.$row['image'].'","pods":['.join(',',$podarray).']}';
        }

        if($results=="")$results='{"name":"'.$view.'","image":"img/configuration/blank.jpg","pods":[]}';
        return $results;
     }

    /**
     * save an inspection record
     * parameters recordid(string),date(string),poddata(string),completed(int),overallstatus(int),overallscore(float)
     * returns array
     */
     public static function saveInspectionRecord($recordid,$date,$poddata,$completed,$overallstatus,$overallscore)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        //$sql="UPDATE inspection SET pods=:poddata,date=:date,completed=:completed,status=:overallstatus,score=:overallscore WHERE recordid=:recordid";
        $sql="UPDATE inspection SET b_pods=:poddata,date=:date,completed=:completed,status=:overallstatus,score=:overallscore WHERE recordid=:recordid";
        $query = $database->prepare($sql);
        //$parameters = array(':poddata' => $poddata,':date' => $date,':completed' => $completed,':overallstatus' => $overallstatus,':overallscore' => $overallscore,':recordid' => $recordid );
        $parameters = array(':poddata' => Encryption::encrypt($poddata),':date' => $date,':completed' => $completed,':overallstatus' => $overallstatus,':overallscore' => $overallscore,':recordid' => $recordid );
        $results=$query->execute($parameters);
        return $results;
     }

    /**
     * delete an inspection record
     * parameters id(int)
     * returns none
     */
     public static function deleteInspectionRecord($id)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        //check if it is the sole record for that vrn
        $sql="SELECT * FROM inspection WHERE id=:id";
        $query = $database->prepare($sql);
        $parameters = array(':id' => $id);
        $query->execute($parameters);
        $vrn=$query->fetch()->vrn;
        $sql="SELECT COUNT(*) FROM inspection WHERE vrn=:vrn";
        $query = $database->prepare($sql);
        $parameters = array(':vrn' => $vrn);
        $query->execute($parameters);
        $inspections = $query->fetchColumn();
        echo $inspections;
        //delete the inspection record
        $sql="DELETE FROM inspection WHERE id=:id";
        $query = $database->prepare($sql);
        $parameters = array(':id' => $id);
        $query->execute($parameters);
        if($inspections==1){
           self::deleteVehicleConitionRecord($vrn);
        }
     }

    /**
     * delete a condition record
     * parameters vrn(string)
     * returns none
     */
     private static function deleteVehicleConitionRecord($vrn)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql="DELETE FROM vehiclecondition WHERE vrn=:vrn";
        $query = $database->prepare($sql);
        $parameters = array(':vrn' => $vrn);
        $query->execute($parameters);
     }

    /**
     * get a condition record for a given vrn
     * parameters vrn(string)
     * returns array
     */
     public static function getVehicleCondition($vrn)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $results=array();
        $sql="SELECT * FROM inspection WHERE vrn=:vrn ORDER BY date,id";
        $query = $database->prepare($sql);
        $parameters = array(':vrn' => $vrn);
        $query->execute($parameters);
        $inspections=$query->fetchAll(PDO::FETCH_ASSOC);
        $vehicleid=$inspections[0]['vehicleid'];
        $results['vehicleid']=$vehicleid;
        //get mappings for vehicle
        $sql="SELECT name FROM vehicle WHERE id=:vehicleid";
        $query = $database->prepare($sql);
        $parameters = array(':vehicleid' => $vehicleid);
        $query->execute($parameters);
        $results['vehicle']=$query->fetch()->name;
        //For condition schedule is always full inspection
        $scheduleid=1;
        $results['scheduleid']=$scheduleid;
        //get mappings for schedule
        $sql="SELECT value FROM inspectioninterval WHERE id=:scheduleid";
        $query = $database->prepare($sql);
        $parameters = array(':scheduleid' => $scheduleid);
        $query->execute($parameters);
        $results['schedule']=$query->fetch()->value;
        $results['unit']=$inspections[0]['unit'];
        $results['vrn']=$inspections[0]['vrn'];
        $results['user']=$inspections[0]['user'];
        $results['recordid']=$inspections[0]['recordid'];
        $results['pods']=json_decode(Encryption::decrypt($inspections[0]['b_pods']),true);
        $results['date']=$inspections[0]['date'];
        $results['odometer']=$inspections[0]['odometer'];
        $results['year']=date('Y', strtotime($inspections[0]['date']));
        //get pods structure
        $pods=array();
        //$version=$inspections[0]['version'];
        $version=end($inspections)['version'];
        $results['version']=$version;
        $sql="SELECT b_poddata,name FROM view WHERE vehicleid=:vehicleid AND scheduleid=:scheduleid AND version=:version";
        $query = $database->prepare($sql);
        $parameters = array(':vehicleid' => $vehicleid,':scheduleid' => $scheduleid,':version' => $version);
        $query->execute($parameters);
        //echo '[ PDO DEBUG ]: ' . Helper::debugPDO($sql, $parameters);  exit();
        $podstructure=array();
        while ($row = $query->fetch(PDO::FETCH_ASSOC)) {
           $view=$row['name'];
           //decode pod data
           $poddata=json_decode(Encryption::decrypt($row['b_poddata']));
           //print_r($poddata);
           //exit();
           foreach($poddata as $data){
              $podstructure[$data->common->ssiid]=array("view" => $view,"common" => $data->common, "inspection" => $data->inspection);
              if(!array_key_exists($data->common->ssiid,$results['pods'])){
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["ref"]=$data->common->ref;
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["ssiid"]=$data->common->ssiid;
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["flawsize"]="";
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["condemnationcriteria"]=$data->common->SI;
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["observation"]="";
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["complete"]=true;
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["metrics"]=array();
                 foreach($data->inspection->metrics as $metric){
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["metrics"][]=array("id" => $metric->id, "value" => $metric->default);
                 }
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["sketch"]=array();
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]["photo"]=array();
              }
              else{
                 //set initial pod data
                 $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]=$results['pods'][$data->common->ssiid];
                 //set initial propagation data
                 $podstructure[$data->common->ssiid]["propagation"]=array();
                 $podstructure[$data->common->ssiid]["propagation"]['flaw']=array();
                 $podstructure[$data->common->ssiid]["propagation"]['series']=array();

                 //overwite with latest data if pod is complete
                 foreach($inspections as $inspection){
                    $currentpod=json_decode(Encryption::decrypt($inspection['b_pods']),true);
                    if($currentpod[$data->common->ssiid]['complete']){
                       $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]=$currentpod[$data->common->ssiid];
                    }
                    //get flaw propagation data - {"type":"Use","condemnationcriteria":"444","flaw":[0],"series":[[3887,0]],"subtype":"numeric"}
                    //first get RCM version from inspection version and vehicleid
                    $rcmversion=HmsModel::getRCMVersion($inspection['vehicleid'],$inspection['version']);
                    //get RCM data for this reference
                    $rcmdata=json_decode(HmsModel::getRCMData($rcmversion,$data->common->ref),true);
                    $subtype=$rcmdata['RCM50'];
                    $metricType=null;
                    if(array_key_exists('RCM67',$rcmdata))$metricType=$rcmdata['RCM67'];
                    $podstructure[$data->common->ssiid]["propagation"]['type'] = $rcmdata['RCM19'];
                    $podstructure[$data->common->ssiid]["propagation"]['condemnationcriteria'] = $data->common->SI;
                    $podstructure[$data->common->ssiid]["propagation"]['flaw'][] = $currentpod[$data->common->ssiid]['flawsize'];
                    $podstructure[$data->common->ssiid]["propagation"]['metrictype']=$metricType;
                    switch(strtolower($podstructure[$data->common->ssiid]["propagation"]['type'])){
                       case "use":
                       if($metricType){
                         if(strtolower($metricType)=='integer'){
                            $podstructure[$data->common->ssiid]["propagation"]['series'][]=array((int)$inspection['odometer'],(float)$currentpod[$data->common->ssiid]['flawsize']);
                            $podstructure[$data->common->ssiid]["propagation"]['subtype']='numeric';
                         }
                         else if(strtolower($metricType)=='string'){
                            $value=strtolower($currentpod[$data->common->ssiid]['flawsize'])=='no'?1:2;
                            $podstructure[$data->common->ssiid]["propagation"]['series'][]=array((int)$inspection['odometer'],$value);
                            $podstructure[$data->common->ssiid]["propagation"]['subtype']='text';
                         }
                       }
                       else{
                         if(strtolower($subtype)!="y/n"){
                            $podstructure[$data->common->ssiid]["propagation"]['series'][]=array((int)$inspection['odometer'],(float)$currentpod[$data->common->ssiid]['flawsize']);
                            $podstructure[$data->common->ssiid]["propagation"]['subtype']='numeric';

                         }
                         else{
                            $value=strtolower($currentpod[$data->common->ssiid]['flawsize'])=='no'?1:2;
                            $podstructure[$data->common->ssiid]["propagation"]['series'][]=array((int)$inspection['odometer'],$value);
                            $podstructure[$data->common->ssiid]["propagation"]['subtype']='text';
                         }
                       }
                       break;
                       case "time":
                       if($metricType){
                         if(strtolower($metricType)=='integer'){
                            $podstructure[$data->common->ssiid]["propagation"]['series'][]=array($inspection['date'],(float)$currentpod[$data->common->ssiid]['flawsize']);
                            $podstructure[$data->common->ssiid]["propagation"]['subtype']='numeric';
                         }
                         else if(strtolower($metricType)=='string'){
                            $value=strtolower($currentpod[$data->common->ssiid]['flawsize'])=='no'?1:2;
                            $podstructure[$data->common->ssiid]["propagation"]['series'][]=array($inspection['date'],$value);
                            $podstructure[$data->common->ssiid]["propagation"]['subtype']='text';
                         }
                       }
                       else{
                         if(strtolower($subtype)!="y/n"){
                            $podstructure[$data->common->ssiid]["propagation"]['series'][]=array($inspection['date'],(float)$currentpod[$data->common->ssiid]['flawsize']);
                            $podstructure[$data->common->ssiid]["propagation"]['subtype']='numeric';
                         }
                         else{
                            $value=strtolower($currentpod[$data->common->ssiid]['flawsize'])=='no'?1:2;
                            $podstructure[$data->common->ssiid]["propagation"]['series'][]=array($inspection['date'],$value);
                            $podstructure[$data->common->ssiid]["propagation"]['subtype']='text';
                         }
                       }
                       break;
                    }
                    $podstructure[$data->common->ssiid]["data"][$data->common->ssiid]['complete']=true;
                 }
              }
           }
        }
        $results['poddata']=json_encode($podstructure,JSON_PRETTY_PRINT);
        return $results;
     }

    /**
     * update a condition record
     * parameters vehicleid(int),version(int),vrn(string),unit(string),overallscore(float),missionscore(float),safetyscore(float),status(int)
     * returns string
     */
     public static function updateCondition($vehicleid,$version,$vrn,$unit,$overallscore,$missionscore,$safetyscore,$status)
     {
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql="SELECT * FROM vehiclecondition WHERE vrn=:vrn AND vehicleid=:vehicleid";
        $query = $database->prepare($sql);
        $parameters = array(':vrn' => $vrn,':vehicleid' => $vehicleid);
        $query->execute($parameters);
        if($query->fetch(PDO::FETCH_NUM) > 0){
           $sql="UPDATE vehiclecondition SET version=:version,unit=:unit,overallscore=:overallscore,missionscore=:missionscore,safetyscore=:safetyscore,status=:status WHERE vehicleid=:vehicleid AND vrn=:vrn ";
           $query = $this->db->prepare($sql);
           $parameters = array(':version'=> $version,':unit' => $unit, ':overallscore' => $overallscore, ':missionscore' => $missionscore, ':safetyscore' => $safetyscore,':status' => $status, ':vehicleid' => $vehicleid, ':vrn' => $vrn);
           $query->execute($parameters);
        }
        else{
           $sql="INSERT INTO vehiclecondition (id,vehicleid,version,vrn,unit,overallscore,missionscore,safetyscore,status) VALUES (NULL,:vehicleid,:version,:vrn,:unit,:overallscore,:missionscore,:safetyscore,:status)";
           $query = $database->prepare($sql);
           $parameters = array(':vehicleid' => $vehicleid,':version'=> $version,':vrn' => $vrn,':unit' => $unit, ':overallscore' => $overallscore, ':missionscore' => $missionscore, ':safetyscore' => $safetyscore,':status' => $status);
           $query->execute($parameters);
        }
        return "saved";
     }
}